<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContactPerson extends Model 
{

    protected $table = 'contact_persons';
    public $timestamps = true;
    protected $fillable = array('client_id', 'position_id', 'line', 'skype', 'wechat', 'whatsapp', 'bbm', 'nohp', 'email');

    public function clients()
    {
        return $this->belongsTo('App\Models\Client', 'client_id');
    }

    public function company_positions()
    {
        return $this->hasOne('App\Models\CompanyPosition', 'position_id');
    }

}